<?php
/**
 * The template for displaying archive pages
 *
 * @author      NanoAgency
 * @link        http://nanoagency.co
 * @copyright   Copyright (c) 2015 NanoAgency
 * @license     GPL v2
 */
get_header();

$title              = get_theme_mod('nerubian_post_title_heading',true);
$layout_content     = get_theme_mod('nerubian_layout_cat_content', 'list');

$content_description     = get_theme_mod('nerubian_post_entry_content', true);

$content_des='hidden-description';
if($content_description){
    $content_des='show-description';
}

$content_col   = get_theme_mod('nerubian_number_post_cat', '1');
if ($content_col==='2'){
    $class='col-md-6 col-xs-12';
}
elseif ($content_col==='3'){
    $class='col-md-4 col-xs-12';
}
elseif ($content_col==='4'){
    $class='col-md-3 col-xs-12';
}else{
    $class='col-md-12';
}

//get
if(isset($_GET['col'])){
    $class=$_GET['col'];
}
if(isset($_GET['des'])){
    $content_des=$_GET['des'];
}
if(isset($_GET['content'])){
    $layout_content=$_GET['content'];
}

?>

<div class="container has-padding-top">
    <div class="row">
        <div class="main-content col-sm-12 col-md-9 col-lg-9 content-right " role="main">
            <?php if ( have_posts() ) : ?>
            <div class="archive-blog row">
                <?php
                // Start the Loop.
                $n=1;
                while ( have_posts() ) : the_post(); ?>
                    <?php if($n==1):?>
                        <div class="item-post col-item col-xs-12">
                            <?php get_template_part( 'templates/layout/content-list-large'); ?>
                        </div>
                    <?php else:?>
                        <div class="item-post col-item <?php echo esc_attr($class);?> <?php echo esc_attr($content_des);?>">
                            <?php get_template_part( 'templates/layout/content' ,$layout_content); ?>
                        </div>
                    <?php endif;?>

                <?php $n++; endwhile;

                else :
                    // If no content, include the "No posts found" template.
                    get_template_part( 'content', 'none' );

                endif;
                the_posts_pagination( array(
                    'prev_text'          => '<i class="fa fa-angle-left"></i>',
                    'next_text'          => '<i class="fa fa-angle-right"></i>',
                    'before_page_number' => '<span class="meta-nav screen-reader-text"></span>',

                ) );
                ?>
            </div>

        </div><!-- .site-main -->

        <div id="archive-sidebar" class="sidebar sidebar-right  hidden-sx hidden-sm col-sx-12 col-sm-12 col-md-3 col-lg-3 archive-sidebar">
            <?php get_sidebar('sidebar'); ?>
        </div>

    </div><!-- .content-area -->
</div>
<?php get_footer(); ?>
